% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap07multinomial.R
\name{wrap.multinomial}
\alias{wrap.multinomial}
\title{Prepare Data on Multinomial Manifold}
\usage{
wrap.multinomial(input)
}
\arguments{
\item{input}{data vectors to be wrapped as \code{riemdata} class. Following inputs are considered,
\describe{
\item{matrix}{an \eqn{(n \times p)} matrix of row observations.}
\item{list}{a length-\eqn{n} list whose elements are length-\eqn{p} vectors.}
}}
}
\value{
a named \code{riemdata} S3 object containing
\describe{
  \item{data}{a list of \eqn{(p\times 1)} matrices in \eqn{\Delta^{p-1}}.}
  \item{size}{dimension of the ambient space.}
  \item{name}{name of the manifold of interests, \emph{"multinomial"}}
}
}
\description{
Multinomial manifold is referred to the data that is nonnegative and sums to 1. 
Also known as probability simplex or positive orthant, we denote \eqn{(p-1)} simplex 
in \eqn{\mathbf{R}^p} by 
\deqn{\Delta^{p-1} = \lbrace
x \in \mathbf{R}^p~\vert~ \sum_{i=1}^p x_i = 1, x_i > 0
\rbrace}
in that data are positive \eqn{L_1} unit-norm vectors. 
In \code{wrap.multinomial}, normalization is applied when each data point is not on the simplex, 
but if vectors contain values not in \eqn{(0,1)}, it returns errors.
}
\examples{
#-------------------------------------------------------------------
#                 Checker for Two Types of Inputs
#-------------------------------------------------------------------
## DATA GENERATION
d1 = array(0,c(5,3))
d2 = list()
for (i in 1:5){
  single  = abs(stats::rnorm(3))
  d1[i,]  = single
  d2[[i]] = single
}

## RUN
test1 = wrap.multinomial(d1)
test2 = wrap.multinomial(d2)

}
\concept{wrapper}
