% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMWEx.R
\name{EMWEx}
\alias{EMWEx}
\title{The Exponentiated Modifien Weibull Extension family}
\usage{
EMWEx(mu.link = "log", sigma.link = "log", nu.link = "log", tau.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}

\item{tau.link}{defines the tau.link, with "log" link as the default for the tau parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a EMWEx distribution in the \code{gamlss()} function.
}
\description{
The Exponentiated Modifien Weibull Extension family
}
\details{
The Beta-Weibull distribution with parameters \code{mu}, 
\code{sigma}, \code{nu} and \code{tau} has density given by

\eqn{f(x)= \nu \sigma \tau (\frac{x}{\mu})^{\sigma-1} \exp((\frac{x}{\mu})^\sigma +
\nu \mu (1- \exp((\frac{x}{\mu})^\sigma))) 
(1 - \exp (\nu\mu (1- \exp((\frac{x}{\mu})^\sigma))))^{\tau-1} ,}

for \eqn{x > 0}, \eqn{\nu> 0}, \eqn{\mu > 0}, \eqn{\sigma> 0} and \eqn{\tau > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma, nu and tau
y <- rEMWEx(n=100, mu = 1, sigma =1.21, nu=1, tau=2)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, tau.fo=~1, family=EMWEx,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma, nu and tau
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))
exp(coef(mod, what='tau'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- runif(n, min=0.4, max=0.6)
x2 <- runif(n, min=0.4, max=0.6)
mu <- exp(0.75 - x1)
sigma <- exp(0.5 - x2)
nu <- 1
tau <- 2
x <- rEMWEx(n=n, mu, sigma, nu, tau)

mod <- gamlss(x~x1, sigma.fo=~x2, nu.fo=~1, tau.fo=~1, family=EMWEx,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
exp(coef(mod, what="nu"))
exp(coef(mod, what="tau"))
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Sarhan, A. M., & Apaloo, J. (2013). Exponentiated modified 
Weibull extension distribution. 
Reliability Engineering & System Safety, 112, 137-144.
}
\seealso{
\link{dEMWEx}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
