% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_advanced.R
\name{crops_detect}
\alias{crops_detect}
\title{CROPS - Changepoints for a Range of Penalties}
\usage{
crops_detect(
  data,
  penalty_range = c(0.1, 100),
  method = "pelt",
  min_segment = 2
)
}
\arguments{
\item{data}{Numeric vector}

\item{penalty_range}{Vector of length 2: c(min_penalty, max_penalty)}

\item{method}{Segmentation method ("pelt" or "fpop")}

\item{min_segment}{Minimum segment length}
}
\value{
List with:
\item{penalties}{Penalty values tested}
\item{n_changepoints}{Number of changepoints for each penalty}
\item{changepoints}{List of changepoint vectors}
\item{costs}{Optimal costs}
}
\description{
Efficiently computes optimal segmentations for a range of penalty
values, useful for model selection.
}
\references{
Haynes, K., Eckley, I. A., and Fearnhead, P. (2017). Computationally
efficient changepoint detection for a range of penalties. Journal
of Computational and Graphical Statistics, 26(1), 134-143.
}
