% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dats}
\alias{dats}
\title{Collection of Survival Datasets (dats)}
\format{
A list containing 7 data frames. Each data frame includes:
\describe{
\item{V1}{Time to event (numeric).}
\item{V2}{Event indicator (0 = censored, 1 = event; numeric).}
\item{V3}{Group identifier (numeric or categorical).}
}

The datasets in \code{dats} are:
\itemize{
\item \strong{Liang}: Derived from Liang et al. (2019).
\item \strong{Spigel}: Derived from Spigel et al. (2022).
\item \strong{Wu}: Derived from Wu et al. (2015).
\item \strong{Wei}: Derived from Wei et al. (2020).
\item \strong{Lima}: Derived from Lima et al. (2018).
\item \strong{Yoshioka}: Derived from Yoshioka et al. (2019).
\item \strong{Seto}: Derived from Seto et al. (2020).
}
}
\source{
\itemize{
\item Maria Thurow et al. (2024). "How to Simulate Realistic Survival Data? A Simulation Study to Compare Realistic Simulation Models"
\emph{arXiv preprint}, \url{https://arxiv.org/abs/2308.07842}.
\item Original datasets from respective publications (see dataset
documentation for details).
\item Data reconstructed using the algorithm by Guyot et al. (2012),
\emph{BMC Medical Research Methodology}, \doi{10.1186/1471-2288-12-9}.
\item Data digitized using WebPlotDigitizer (Rohatgi, A.),
\url{https://automeris.io/WebPlotDigitizer}.
}
}
\usage{
data(dats)
}
\description{
\code{dats} is a collection of seven survival datasets used for testing and
simulation of survival data. These datasets were reconstructed from published
Kaplan-Meier survival curves using the widely applied algorithm by Guyot et al. (2012).
The datasets were originally sourced from various clinical studies and digitized
using WebPlotDigitizer. They are used as benchmarks for synthetic survival data methods,
including kernel density estimation, parametric distribution fitting, and bootstrap
resampling.
}
\examples{
data(dats)
names(dats)
head(dats$Liang)
}
\keyword{datasets}
