% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace.R
\name{laplace}
\alias{laplace}
\alias{dlaplace}
\alias{plaplace}
\alias{qlaplace}
\alias{rlaplace}
\title{Laplace distribution}
\usage{
dlaplace(x, mu = 0, b = 1, eps = NULL, log = FALSE)

plaplace(q, mu = 0, b = 1, lower.tail = TRUE, log.p = FALSE)

qlaplace(p, mu = 0, b = 1, lower.tail = TRUE, log.p = FALSE)

rlaplace(n, mu = 0, b = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter}

\item{b}{scale parameter, must be positive.}

\item{eps}{optional smoothing parameter for \code{dlaplace} to smooth the absolute value function. See \code{\link{abs_smooth}} for details.
It is recommended to set this to a small constant like \code{1e-6} for numerical optimisation.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dlaplace} gives the density, \code{plaplace} gives the distribution function, \code{qlaplace} gives the quantile function, and \code{rlaplace} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Laplace distribution.
}
\details{
This implementation of \code{dlaplace} allows for automatic differentiation with \code{RTMB}.
}
\examples{
x <- rlaplace(1, 1, 1)
d <- dlaplace(x, 1, 1)
p <- plaplace(x, 1, 1)
q <- qlaplace(p, 1, 1)
}
