% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learn_escalation_rule.R
\name{learn_escalation_rule}
\alias{learn_escalation_rule}
\title{Build an Optimal Dose Escalation Rule using Reinforcement Learning}
\usage{
learn_escalation_rule(
  J,
  target,
  epsilon,
  delta,
  N_total,
  N_cohort,
  seed = NULL,
  rl_config = rl_config_set(),
  rl_scenarios = NULL,
  output_dir = format(Sys.time(), "\%Y\%m\%d_\%H\%M\%S"),
  output_base_dir = "escalation_rules",
  checkpoint_dir = "checkpoints"
)
}
\arguments{
\item{J}{A positive integer value. The number of doses.}

\item{target}{A positive numeric value. The target DLT probability.}

\item{epsilon}{A positive numeric value. The acceptable range of target DLT
probabilities is defined as [\code{target} - \code{epsilon}, \code{target} + \code{epsilon}].}

\item{delta}{A positive numeric value. The unacceptable ranges of target DLT
probabilities are defined as [0, \code{target} - \code{delta}] and
[\code{target} + \code{delta}, 1].}

\item{N_total}{A positive integer value. The total number of patients.}

\item{N_cohort}{A positive integer value. The number of patients for each cohort.}

\item{seed}{An integer value. Random seed for reinforcement learning.}

\item{rl_config}{A list. Other settings for reinforcement learning. See
\link{rl_config_set} for details.}

\item{rl_scenarios}{A list. Scenarios used for reinforcement learning.
Default is \code{NULL} (use scenarios in the Sect. 2.2 of the original paper).
See \link{compute_rl_scenarios} for details.}

\item{output_dir}{A character value. Directory name or path to store the
built escalation rule. Default is the current datetime.}

\item{output_base_dir}{A character value. Parent directory path where the
built escalation rule will be stored. Valid only if 'output_dir' does
not contain '/'. Default is "escalation_rules".}

\item{checkpoint_dir}{A character value. Parent directory path to save
checkpoints. It enables you to resume learning from that point onwards.
Default is "checkpoints".}
}
\value{
An \link{EscalationRule} object.
}
\description{
Build an Optimal Dose Escalation Rule using Reinforcement Learning
}
\examples{
library(RLescalation)

# We obtain an optimal dose escalation rule by executing `learn_escalation_rule()`.
\dontrun{
escalation_rule <- learn_escalation_rule(
  J = 6, target = 0.25, epsilon = 0.04, delta = 0.1,
  N_total = 36, N_cohort = 3, seed = 123,
  rl_config = rl_config_set(iter = 1000)
)}

}
