% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode}
\alias{encode}
\title{Encoding with Diffusion Maps}
\usage{
encode(rf, x, k = 5L, stepsize = 1L, parallel = TRUE)
}
\arguments{
\item{rf}{Pre-trained random forest object of class \code{ranger}.}

\item{x}{Training data for estimating embedding weights.}

\item{k}{Dimensionality of the spectral embedding.}

\item{stepsize}{Number of steps of a random walk for the diffusion process.
See Details.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}
}
\value{
A list with eight elements: (1) \code{Z}: a \code{k}-dimensional nonlinear
embedding of \code{x} implied by \code{rf}. (2) \code{A}: the normalized
adjacency matrix (3) \code{v}: the leading \code{k} eigenvectors;
(4) \code{lambda}: the leading \code{k} eigenvalues; (5) \code{stepsize}: the
number of steps in the random walk. (6) \code{leafIDs}: a matrix with
\code{nrow(x)} rows and \code{rf$num.trees} columns, representing the
terminal nodes of each training sample in each tree; (7) the number of
samples in each leaf; (8) metadata about the \code{rf}.
}
\description{
Computes the diffusion map of a random forest kernel, including a spectral
decomposition and associated weights.
}
\details{
\code{encode} learns a low-dimensional embedding of the data implied by the
adjacency matrix of the \code{rf}. Random forests can be understood as an
adaptive nearest neighbors algorithm, where proximity between samples is
determined by how often they are routed to the same leaves. We compute the
spectral decomposition of the model adjacencies over the training data
\code{X}, and take the leading \code{k} eigenvectors and eigenvalues. The
function returns the resulting diffusion map, eigenvectors, eigenvalues,
and leaf sizes.

Let \eqn{K} be the weighted adjacency matrix of code \code{x} implied by
\code{rf}. This defines a weighted, undirected graph over the training data,
which we can also interpret as the transitions of a Markov process 'between'
data points. Spectral analysis produces the decomposition \eqn{K = V\lambda V^{-1}},
where we can take leading nonconstant eigenvectors. The diffusion map
\eqn{Z = \sqrt{n} V \lambda^{t}} (Coifman & Lafon, 2006) represents the
long-run connectivity structure of the graph after t time steps of a Markov
process, with some nice optimization properties (von Luxburg, 2007). We can
embed new data into this space using the Nyström formula (Bengio et al.,
2004).
}
\examples{
# Train ARF
arf <- arf::adversarial_rf(iris)

# Embed the data
emap <- encode(arf, iris)


}
\references{
Bengio, Y., Delalleau, O., Le Roux, N., Paiement, J., Vincent, P., & Ouimet,
M. (2004). Learning eigenfunctions links spectral embedding and kernel PCA.
\emph{Neural Computation, 16}(10): 2197-2219.

Coifman, R. R., & Lafon, S. (2006). Diffusion maps. \emph{Applied and
Computational Harmonic Analysis, 21}(1), 5–30.

von Luxburg, U. (2007). A tutorial on spectral clustering. \emph{Statistics
and Computing, 17}(4), 395–416.
}
\seealso{
\code{\link[arf]{adversarial_rf}}
}
