% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{qq_export}
\alias{qq_export}
\title{Export QQ Results to CSV}
\usage{
qq_export(qq_result, file, digits = 4)
}
\arguments{
\item{qq_result}{An object of class "qq_regression".}

\item{file}{Character string. Path to the output file.}

\item{digits}{Integer. Number of decimal places for rounding. Default is 4.}
}
\value{
Invisible \code{NULL}. Called for its side effect of writing
  a CSV file.
}
\description{
Exports QQ regression results to a CSV file.
}
\examples{
\donttest{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

# Export to CSV
qq_export(result, file.path(tempdir(), "qq_results.csv"))
}

}
