#' @title QuantileOnQuantile: Quantile-on-Quantile Regression Analysis
#'
#' @description
#' The QuantileOnQuantile package implements the Quantile-on-Quantile (QQ) 
#' regression methodology developed by Sim and Zhou (2015). This approach 
#' estimates the effect that quantiles of one variable have on quantiles 
#' of another, capturing the dependence between their distributions.
#'
#' @details
#' The package provides the following main functions:
#'
#' \strong{Core Functions:}
#' \describe{
#'   \item{\code{\link{qq_regression}}}{Main function for performing QQ 
#'     regression analysis.}
#'   \item{\code{\link{qq_statistics}}}{Compute summary statistics for 
#'     QQ regression results.}
#' }
#'
#' \strong{Visualization Functions:}
#' \describe{
#'   \item{\code{\link{plot_qq_3d}}}{Create 3D surface plots with MATLAB-style 
#'     and other color schemes.}
#'   \item{\code{\link{plot_qq_heatmap}}}{Create heatmaps of coefficients, 
#'     R-squared, or p-values.}
#'   \item{\code{\link{plot_qq_contour}}}{Create contour plots.}
#'   \item{\code{\link{plot_qq_correlation}}}{Create quantile correlation 
#'     heatmaps.}
#' }
#'
#' \strong{Utility Functions:}
#' \describe{
#'   \item{\code{\link{qq_colorscales}}}{Display available color scales.}
#'   \item{\code{\link{qq_to_matrix}}}{Convert results to matrix format.}
#'   \item{\code{\link{qq_export}}}{Export results to CSV.}
#' }
#'
#' @section Color Scales:
#' The package supports multiple color scales for visualization:
#' \itemize{
#'   \item \strong{Jet}: MATLAB-style rainbow (blue to red through green)
#'   \item \strong{BlueRed}: Diverging scale (blue = negative, red = positive)
#'   \item \strong{Viridis}: Perceptually uniform, colorblind-friendly
#'   \item \strong{Plasma}: Perceptually uniform, high contrast
#' }
#'
#' @section Methodology:
#' The QQ approach combines quantile regression with local linear regression.
#' For each quantile tau of the independent variable and each quantile theta 
#' of the dependent variable, the method estimates the local effect of x on y.
#' This allows researchers to examine how relationships vary across different 
#' parts of the distributions.
#'
#' @references
#' Sim, N. and Zhou, H. (2015). Oil Prices, US Stock Return, and the 
#' Dependence Between Their Quantiles. \emph{Journal of Banking & Finance}, 
#' 55, 1-12. \doi{10.1016/j.jbankfin.2015.01.013}
#'
#' @seealso
#' \code{\link[quantreg]{rq}} for the underlying quantile regression function.
#'
#' @author
#' Merwan Roudane \email{merwanroudane920@@gmail.com}
#'
#' Based on the methodology developed by:
#' \itemize{
#'   \item Nicholas Sim (University of Adelaide)
#'   \item Hongtao Zhou (Shandong University)
#' }
#'
#' @keywords package
#' @docType package
#' @name QuantileOnQuantile-package
#' @aliases QuantileOnQuantile
"_PACKAGE"
