% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encodeCat.R
\name{encodeCat}
\alias{encodeCat}
\title{One-Hot Encodes Factor Variables (FIRST Level as Reference)}
\usage{
encodeCat(dataframe)
}
\arguments{
\item{dataframe}{A \code{data.frame} containing the data to be processed, which may include factor variables.}
}
\value{
A \code{data.frame} where:
\itemize{
  \item{All original non-factor columns are present.}
  \item{All original factor columns are replaced by a set of binary (0/1) dummy variables. The first level of the factor is excluded from the generated dummies, making the last level the reference.}
}
}
\description{
This function takes a dataframe, identifies all columns of class \code{factor}, and converts them into **dummy variables** using one-hot encoding via \code{stats::model.matrix}. For each factor, the function explicitly removes the first dummy variable generated, effectively making the **first level** of the factor the **reference level** (omitted category). Non-factor columns are retained as is.
}
\examples{
data("exposure_data")
exp_data = exposure_data$df
covList = {}
covList$FE = c('X')
XFE = encodeCat(exp_data[,covList$FE, drop = FALSE])
}
