% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bilateral_indices.R
\name{retro_index}
\alias{retro_index}
\title{Calculating the retrospective price index}
\usage{
retro_index(
  data,
  start,
  end,
  formula = "fisher",
  approach = "correction",
  method_index = "additive",
  method_weights = "additive",
  lambda = "linear",
  sigma = 0.7,
  df = FALSE,
  name = "RETRO_index"
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{prodID} (as numeric, factor or character). A column \code{quantities} (as positive numeric) is also needed because this function uses unit values as monthly prices.}

\item{start}{The base period, being the first expenditure reference period (as character), limited to the year and month, e.g. "2020-03". We assume that the quantity (and thus expenditure) information is available for this period.}

\item{end}{The second expenditure reference period (as character) limited to the year and month, e.g. "2020-04". We assume that the quantity (and thus expenditure) information is available for this period.}

\item{formula}{A parameter indicating which index formula to use within the \code{correction} or \code{imputation} approach, with the values 'fisher' and 'tornqvist' available. If the parameter value is set to 'dhkh', then the retrospective Diewert-Huwiler-Kohli-Hansen index (DHKH) will be computed instead of the correction or imputation method.}

\item{approach}{A parameter indicating which approach to use to obtain retrospectively computed price indices. Available options are: 'correction', 'imputation', 'correction-imputation', or 'CES-imputation'.}

\item{method_index}{A parameter indicating how to apply the correction approach. Available options are: 'additive' and 'multiplicative'.}

\item{method_weights}{A parameter indicating how to apply the imputation approach for calculating weights for all periods within the time interval. Available options are: 'additive' and 'multiplicative'.}

\item{lambda}{A parameter indicating the relevance of the second expenditure reference period relative to the relevance of the first (base) expenditure reference period. Available options are: 'linear' and 'sinusoidal'.}

\item{sigma}{A parameter indicating elasticity of substitution.}

\item{df}{A parameter indicating whether the function should return a data frame with dates and retrospective index values (TRUE) or just a vector of its values for subsequent months (FALSE).}

\item{name}{A parameter indicating the index (or method) name returned in a resulting data frame.}
}
\value{
The function returns values of the selected retrospective price index for all period between \code{start} and \code{end} (\code{start} is always the fixed base period). Depending on the \code{formula} parameter it can provide values of the Diewert-Huwiler-Kohli-Hansen index (DHKH) or run correction and imputation approach, as well as the mixture of them, to obtain a vector (or a data frame) of retrospective price indices. Note that the 'CES-imputation' approach requires elasticity of substitution. The user may control the relevance of the second expenditure reference period (\code{end}) relative to the relevance of the first (base) expenditure reference period (\code{start}) by using the \code{lambda} parameter.
}
\description{
This function returns values of the selected retrospective price index.
}
\examples{
\donttest{retro_index(milk, start="2018-12",end="2019-04",formula="dhkh", df=TRUE)}
\donttest{retro_index(milk, start="2018-12",end="2019-04", approach="correction", 
method_index = "multiplicative", lambda="sinusoidal")}
}
\references{
{Diewert, E. W., Huwiler, M., Kohli, U. (2009). \emph{Retrospective approximations of superlative price indexes for years where expenditure data is unavailable}. In: Biggeri, L., Ferrari, G. (eds), \emph{Price indexes in time and space. Contributions to statistics.}, Physica-Verlag, Heidelberg, 25-42.}

{von Auer, L., (2024). \emph{Retrospective computations of price index numbers: theory and application}. Review of Income and Wealth, 70(1), 60-79.}
}
