% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HM.R
\name{HM}
\alias{HM}
\title{Harmonic Mean (HM)}
\usage{
HM(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A data frame with \code{Gen}, \code{HM}.

\deqn{HM = \frac{2 \times YN \times YS}{YN + YS}}
}
\description{
This function computes Harmonic Mean (HM) using any traits (like yield) under stress and non-stress conditions. The lower values of HM indicates greater tolerance. For more details see Bidinger et al. (1987) \url{doi:10.1071/AR9870037}.
}
\examples{
out = HM(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Bidinger, F.R., Mahalakshmi, V. and Rao, G.D.P. (1987). \url{doi:10.1071/AR9870037}.
}
