% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypeDiagnostics.R
\name{phenotypeDiagnostics}
\alias{phenotypeDiagnostics}
\title{Phenotype a cohort}
\usage{
phenotypeDiagnostics(
  cohort,
  diagnostics = c("databaseDiagnostics", "codelistDiagnostics", "cohortDiagnostics",
    "populationDiagnostics"),
  measurementSample = 20000,
  drugExposureSample = 20000,
  survival = FALSE,
  cohortSample = 20000,
  matchedSample = 1000,
  populationSample = 1e+06,
  populationDateRange = as.Date(c(NA, NA))
)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{diagnostics}{Vector indicating which diagnostics to perform. Options
include: `databaseDiagnostics`, `codelistDiagnostics`, `cohortDiagnostics`,
and `populationDiagnostics`.}

\item{measurementSample}{The number of people to take a random sample for
measurement diagnostics. If `measurementSample = NULL`, no sampling will be
performed. If `measurementSample = 0` measurement diagnostics will not be
run.}

\item{drugExposureSample}{The number of people to take a random sample for
drug diagnostics. If `drugExposureSample = NULL`, no sampling will be
performed. If `drugExposureSample = 0` drug diagnostics will not be
run.}

\item{survival}{TRUE or FALSE. Whether to conduct survival analysis (TRUE)
or not (FALSE).}

\item{cohortSample}{The number of people to take a random sample for cohortDiagnostics. If `cohortSample = NULL`, no sampling will be performed.}

\item{matchedSample}{The number of people to take a random sample for
matching. If `matchedSample = NULL`, no sampling will be performed. If `matchedSample = 0`, no
matched cohorts will be created.}

\item{populationSample}{Number of people from the cdm to sample. If NULL no
sampling will be performed. Sample will be within populationDateRange if
specified.}

\item{populationDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}
}
\value{
A summarised result
}
\description{
This comprises all the diagnostics that are being offered in this package,
this includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
}
\examples{
\donttest{
library(omock)
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockCdmFromDataset(source = "duckdb")
cdm$warfarin <- conceptCohort(cdm,
                              conceptSet =  list(warfarin = c(1310149L,
                                                              40163554L)),
                              name = "warfarin")

result <- phenotypeDiagnostics(cdm$warfarin)
}
}
