% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelistDiagnostics.R
\name{codelistDiagnostics}
\alias{codelistDiagnostics}
\title{Run codelist-level diagnostics}
\usage{
codelistDiagnostics(
  cohort,
  measurementSample = 20000,
  drugExposureSample = 20000
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference. The cohort_codelist
attribute must be populated. The cdm reference must contain achilles
tables as these will be used for deriving concept counts.}

\item{measurementSample}{The number of people to take a random sample for
measurement diagnostics. If `measurementSample = NULL`, no sampling will be
performed. If `measurementSample = 0` measurement diagnostics will not be
run.}

\item{drugExposureSample}{The number of people to take a random sample for
drug diagnostics. If `drugExposureSample = NULL`, no sampling will be
performed. If `drugExposureSample = 0` drug diagnostics will not be
run.}
}
\value{
A summarised result
}
\description{
`codelistDiagnostics()` runs phenotypeR diagnostics on the cohort_codelist
attribute on the cohort. Thus codelist attribute of the cohort must be
populated. If it is missing then it could be populated using
`addCodelistAttribute()` function.

Furthermore `codelistDiagnostics()` requires achilles tables to be present in
the cdm so that concept counts could be derived.
}
\examples{
\donttest{
library(omock)
library(CohortConstructor)
library(PhenotypeR)

cdm <- mockCdmFromDataset(source = "duckdb")
cdm$warfarin <- conceptCohort(cdm,
                              conceptSet =  list(warfarin = c(1310149L,
                                                              40163554L)),
                              name = "warfarin")
result <- codelistDiagnostics(cdm$warfarin)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
