% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsToTableByRaw.R
\name{modsToTableByRaw}
\alias{modsToTableByRaw}
\title{Convert list of (mixed)modifications to a frequency table}
\usage{
modsToTableByRaw(
  df_evd,
  name_unmod = "Unmodified",
  name_unmod_inverse = "Modified (total)"
)
}
\arguments{
\item{df_evd}{data.frame with 'fc.raw.file' and a 'modifications' column, which contains the modifications for each peptide.}

\item{name_unmod}{String in 'modifications' which represents an unmodified peptide}

\item{name_unmod_inverse}{If non-empty, then inverse the frequencies of the 'name_unmod' modifications (i.e. 100-x) IFF they are >=50\% on average (across Raw files) and rename them to this string}
}
\value{
A data.table with 'fc.raw.file', 'modification_names' (factor), and 'Freq' (0-100)
}
\description{
Convert list of (mixed)modifications to a frequency table
}
\examples{
data = data.frame(fc.raw.file = rep(c("file A", "file B"),
                                each = 3),
       modifications = c("Oxidation (M)",
                        "Unmodified",
                        "Oxidation (M),Acetyl (Protein N-term)",
                        "2 Oxidation (M)",
                        "Unmodified", "Unmodified"))
modsToTableByRaw(data)


}
