% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U04-censoring-scores.R
\name{estimate_censoring_score_weibull}
\alias{estimate_censoring_score_weibull}
\title{Censoring Score Estimation}
\usage{
estimate_censoring_score_weibull(
  data,
  time_var,
  treatment_var,
  formula,
  control = list(maxiter = 350)
)
}
\arguments{
\item{data}{Data frame.}

\item{time_var}{Name of time variable.}

\item{treatment_var}{Name of treatment variable.}

\item{formula}{Censoring model formula. Use \code{Surv(time, censor_indicator) ~ X1 + X2}
where \code{censor_indicator = 1} indicates censoring. If event is coded
canonically (event=1, censored=0), use \code{I(1-event)}. Otherwise, use
the appropriate transformation. Treatment is automatically removed if included.}

\item{control}{Control parameters for \code{survreg()}. Default
\code{list(maxiter = 350)}.}
}
\value{
List with class "censoring_score_weibull":
  \item{censoring_models}{Fitted \code{survreg} objects by treatment level.}
  \item{censoring_scores}{P(C >= T_i | Z_i, X_i) for observed treatment.}
  \item{censoring_matrix}{(n x J) matrix of P(C >= T_i | Z=j, X_i).}
  \item{n_levels}{Number of treatment levels.}
  \item{treatment_levels}{Sorted treatment values.}
  \item{model_type}{"weibull".}
  \item{parameters}{Transformed parameters (\code{theta}, \code{gamma}, \code{coef},
    \code{vcov}, \code{scale}) by treatment level.}
  \item{linear_predictors_matrix}{(n x J) matrix of linear predictors.}
}
\description{
Estimate censoring scores P(C >= T | X) using Weibull or Cox models fit
separately within each treatment group.
Estimate Censoring Scores Using Weibull Regression
}
\details{
Fits Weibull models within each treatment group. Censoring scores computed as:
\deqn{K_c^{(j)}(t, X) = \exp(-\exp(X'\theta_j) \cdot t^{\gamma_j})}
where \eqn{\theta_j = -\beta_j/\sigma_j}, \eqn{\gamma_j = 1/\sigma_j}.
}
\keyword{internal}
