% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_response}
\alias{plot_response}
\title{Plot the expected response against selected variables}
\usage{
plot_response(
  obj,
  vars,
  log_scale = FALSE,
  length.out = 20,
  color = "blue",
  size = 1.5
)
}
\arguments{
\item{obj}{An object of class \code{"PSTR"}.}

\item{vars}{Integer vector of column indices from the nonlinear part.}

\item{log_scale}{Logical scalar or length-2 vector indicating whether
to use log scale for the regressor and/or transition variable.}

\item{length.out}{Scalar or length-2 numeric vector controlling grid size.}

\item{color}{Line colour.}

\item{size}{Line width.}
}
\value{
A named list of \code{ggplot2} (curve) and/or
  \code{plotly} (surface) objects.
}
\description{
This function plots the effect-adjusted expected response for selected
nonlinear variables in a PSTR model.
}
\details{
If the selected variable differs from the transition variable,
a 3-D surface of
\deqn{(\beta_{k,0} + \beta_{k,1} g(q;\gamma,c)) z_{k}}
is plotted against \eqn{z_k} and the transition variable.

If the selected variable coincides with the transition variable,
a curve is plotted instead.

In addition to the exported function
\code{plot_response(obj = ...)}, the same functionality is available
as an R6 method via \code{obj$plot_response(...)}.
}
\examples{
\donttest{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
                indep_k = c("vala","debta","cfa","sales"),
                tvars = c("vala","debta","cfa","sales"), iT = 14)

pstr <- EstPSTR(use = pstr, im = 1, iq = 1,
                useDelta = TRUE, par = c(.63,0), method = "CG")

# Exported interface
ret <- plot_response(pstr, vars = 1:4)

# R6 method
ret2 <- pstr$plot_response(vars = 1:4)
}

}
