% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_dataset.R
\name{merge_dataset}
\alias{merge_dataset}
\title{Merge Two Datasets Based on Species Column}
\usage{
merge_dataset(main_data, additional_data, priority = "main")
}
\arguments{
\item{main_data}{A data frame containing the primary dataset. Must include a 'species' column.}

\item{additional_data}{A data frame containing the secondary dataset. Must include a 'species' column.}

\item{priority}{A character string specifying how to handle conflicts when both datasets
contain non-missing values for the same species and column. Options are:
\itemize{
  \item \code{"main"} (default): Use values from main_data
  \item \code{"additional"}: Use values from additional_data
  \item \code{"mean"}: Calculate mean for numeric values, use main_data for non-numeric
}}
}
\value{
A data frame containing all unique species from both input datasets, with
  all columns from both datasets. The 'species' column is placed first, followed
  by all other columns in alphabetical order.
}
\description{
This function merges two data frames based on the 'species' column, handling
missing values and column differences intelligently. It provides flexible
options for resolving conflicts when the same species appears in both datasets.
}
\details{
The function performs the following operations:
\itemize{
  \item Combines all unique species from both datasets
  \item Includes all columns from both datasets
  \item Handles missing values by using available non-missing values
  \item Resolves conflicts based on the specified priority
  \item For duplicate species within a dataset, only the first occurrence is used
}
}
\note{
\itemize{
  \item Both input datasets must contain a 'species' column
  \item If a species appears multiple times in a dataset, only the first occurrence is used
  \item When priority is "mean", non-numeric values default to main_data values
  \item The function preserves the original data types of columns
}
}
\examples{
# Create sample datasets
main_data <- data.frame(
  species = c("Abies alba", "Coussapoa trinervia", "Crataegus monogyna"),
  genus = c("Abies", "Coussapoa", "Crataegus"),
  family = c("Pinaceae", "Urticaceae", "Rosaceae"),
  LA = c(NA, 2050.24, 449.15),
  LeafN = c(13.10, 14.52, 17.46),
  Seedmass = c(53.64, NA, 95.92),
  stringsAsFactors = FALSE
)

additional_data <- data.frame(
  species = c("Abies alba", "Corydalis solida"),
  genus = c("Abies", "Corydalis"),
  family = c("Pinaceae", "Papaveraceae"),
  LA = c(25.58, NA),
  LMA = c(0.19, 0.2),
  PlantHeight = c(53.66, 0.14),
  stringsAsFactors = FALSE
)

# Merge with main data priority (default)
merge_dataset(main_data, additional_data)

}
