% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parents_ordering.R
\name{find_all_orders}
\alias{find_all_orders}
\title{Finds all possible copula assignments given a DAG}
\usage{
find_all_orders(DAG)
}
\arguments{
\item{DAG}{Directed Acyclic Graph}
}
\value{
a list of hashmaps containing the possible orders
}
\description{
Finds all possible copula assignments given a DAG
}
\examples{
DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
all_orders = find_all_orders(DAG)
length(all_orders)
# 8 orders
for (i in 1:length(all_orders)){
  cat("Order ", i, ": \n")
  cat("U3:", all_orders[[i]][['U3']])
  cat(" ; U4:", all_orders[[i]][['U4']], "\n")
}

}
