% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvSGZ.r
\name{InvSGZ}
\alias{InvSGZ}
\alias{dinv.sgz}
\alias{pinv.sgz}
\alias{qinv.sgz}
\alias{rinv.sgz}
\alias{hinv.sgz}
\title{Inverted Shifted Gompertz (ISG) Distribution}
\usage{
dinv.sgz(x, alpha, theta, log = FALSE)
pinv.sgz(q, alpha, theta, lower.tail = TRUE, log.p = FALSE)
qinv.sgz(p, alpha, theta, lower.tail = TRUE, log.p = FALSE)
rinv.sgz(n, alpha, theta)
hinv.sgz(x, alpha, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.sgz}: numeric vector of (log-)densities
  \item \code{pinv.sgz}: numeric vector of probabilities
  \item \code{qinv.sgz}: numeric vector of quantiles
  \item \code{rinv.sgz}: numeric vector of random variates
  \item \code{hinv.sgz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverted Shifted Gompertz distribution.
}
\details{
The Inverted Shifted Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, and \eqn{\theta > 0}.


The Inverted Shifted Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \theta) =
1-\left(1-e^{-\theta / x}\right) \exp \left(-\alpha e^{-\theta / x}\right)  \quad ;\;x > 0.
}

where\eqn{\alpha} and \eqn{\theta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dinv.sgz()} — Density function
  \item \code{pinv.sgz()} — Distribution function
  \item \code{qinv.sgz()} — Quantile function
  \item \code{rinv.sgz()} — Random generation
  \item \code{hinv.sgz()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dinv.sgz(x, 25, 10)
pinv.sgz(x, 25, 10)
qinv.sgz(0.5, 25, 10)
rinv.sgz(10, 25, 10)
hinv.sgz(x, 25, 10)

# Data
x <- fibers65
# ML estimates
params = list(alpha=215.8181, theta=12.7678)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.sgz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.sgz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dinv.sgz, pfun=pinv.sgz, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary, A.K., Sapkota, L.P., & Kumar, V.  (2020). 
Inverted Shifted Gompertz Distribution with Theory and Applications. 
\emph{Pravaha}, \bold{26(1)}, 1--10. \doi{10.3126/pravaha.v26i1.41645}
   
Jimenez T.F. (2014). Estimation of the Parameters of the Shifted Gompertz 
Distribution, Using Least Squares, Maximum Likelihood and Moments Methods. 
\emph{Journal of Computational and Applied Mathematics}, \bold{255(1)} 867--877.
}
