% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{AE}
\alias{AE}
\title{Calculate Agronomic Efficiency (AE)}
\usage{
AE(YieldF, Yield0, FertN)
}
\arguments{
\item{YieldF}{A numeric vector for yield in fertilized conditions.}

\item{Yield0}{A numeric vector of non-fertilized control yield values.}

\item{FertN}{A numeric value or vector for fertilizer N input.}
}
\value{
A numeric vector of AE values.
}
\description{
The contribution of fertilizer N towards yield, compared to a non-fertilized control.
Formula: AE = (YieldF - Yield0) / FertN
}
\examples{
YieldF <- c(10, 12, 15)
Yield0 <- c(5, 5, 5)
FertN <- 50
AE(YieldF, Yield0, FertN)
}
