% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UPM.ratio}
\alias{UPM.ratio}
\title{Upper Partial Moment Ratio}
\usage{
UPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{numeric; degree = 0 gives frequency, degree = 1 gives area.}

\item{target}{numeric vector; threshold(s). Defaults to mean(variable).}

\item{variable}{numeric vector or data‑frame column to evaluate.}
}
\value{
Numeric vector of standardized upper partial moments.
}
\description{
This function generates a standardized univariate upper partial moment
  of any non‑negative degree for a given target.
}
\examples{
  set.seed(123)
  x <- rnorm(100)
  UPM.ratio(0, mean(x), x)
\dontrun{
  plot3d(x, y, Co.UPM(0, sort(x), sort(y), x, y), …)
}
}
\references{
Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
