% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD_Efficient_Set.R
\name{NNS.SD.efficient.set}
\alias{NNS.SD.efficient.set}
\title{NNS SD Efficient Set}
\usage{
NNS.SD.efficient.set(x, degree, type = "discrete", status = TRUE)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{degree}{numeric options: (1, 2, 3); Degree of stochastic dominance test from (1, 2 or 3).}

\item{type}{options: ("discrete", "continuous"); \code{"discrete"} (default) selects the type of CDF.}

\item{status}{logical; \code{TRUE} (default) Prints status update message in console.}
}
\value{
Returns set of stochastic dominant variable names.
}
\description{
Determines the set of stochastic dominant variables for various degrees.
}
\examples{
\dontrun{
set.seed(123)
x <- rnorm(100) ; y<-rnorm(100) ; z<-rnorm(100)
A <- cbind(x, y, z)
NNS.SD.efficient.set(A, 1)
}
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126.  \doi{10.4236/jmf.2016.61012}.

Viole, F. (2017) "A Note on Stochastic Dominance." \doi{10.2139/ssrn.3002675}
}
\author{
Fred Viole, OVVO Financial Systems
}
