#' Summary Method for the Output of the Fitting Method
#'
#' Method for printing the summary of the fitting method. Gives detailed
#' infofmation about the object.
#'
#' @param object An object of class \code{fitStMoMo_list}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Displays a summary of the \code{fitStMoMo_list} object in the console.
#'
#' @export
summary.fitStMoMo_list <- function(object, ...) {
  cat("Summary of fitStMoMo_list object:\n\n")

  names_list <- setdiff(names(object), "NN_fittingModel")
  split_names <- strsplit(names_list, "_")
  countries   <- unique(sapply(split_names, `[`, 1))
  sexes       <- unique(sapply(split_names, `[`, 2))

  cat("  Countries         :", paste(countries, collapse = ", "), "\n")
  cat("  Sexes             :", paste(sexes, collapse = ", "), "\n\n")


  cat("Fitting parameters:\n")
  cat(
    "  Ages fitted:     ",
    paste(range(object$NN_fittingModel$ages.fit), collapse = "-"),
    "\n"
  )
  cat(
    "  Years fitted:    ",
    paste(range(object$NN_fittingModel$years.fit), collapse = "-"),
    "\n"
  )
  cat("  Epochs:          ", object$NN_fittingModel$fitting.epochs, "\n")
  cat("  Batch size:      ", object$NN_fittingModel$batch.size, "\n\n")

  cat("Model configuration:\n")
  cat("  Activation:      ", object$NN_fittingModel$activation, "\n")
  cat("  Model type:      ", object$NN_fittingModel$model_type, "\n")
  cat("  Loss type:       ", object$NN_fittingModel$loss_type, "\n")
  cat("  q_e:             ", object$NN_fittingModel$q_e, "\n")
  cat("  q_z1:            ", object$NN_fittingModel$q_z1, "\n\n")

  cat("Results:\n")
  cat("  Final training loss:", object$NN_fittingModel$final_loss, "\n")
}
