
context("NMrelate")

NMdataConf(reset=TRUE)

test_that("basic",{
    file.mod <- "testData/nonmem/xgxr032.mod"
    fileRef <- "testReference/NMrelateOne_01.rds"
    
    res <- list(
        NMrelateOne(file=file.mod,par.type="eta")
       ,
        NMrelateOne(file.mod,par.type="theta")
       ,
        NMrelateOne(file.mod,par.type="sigma")
    )

    expect_equal_to_reference(res,fileRef)
})

test_that("Find all",{

    file.mod <- "testData/nonmem/xgxr032.mod"
    fileRef <- "testReference/NMrelate_01.rds"

    ## getLines(file.mod)
    res <- NMrelate(file=file.mod)
    
    expect_equal_to_reference(res,fileRef)

    if(F){
        ref <- readRDS(fileRef)
        ref
        res
        }
})


test_that("merge with NMreadExt results",{

    file.mod <- "testData/nonmem/xgxr032.mod"
    fileRef <- "testReference/NMrelate_02.rds"

    res.rel <- NMrelate(file=file.mod)
    res.ext <- NMreadExt(file=file.mod,as.fun="data.table")

    res <- list(
        ext.all=mergeCheck(res.ext[!is.na(par.type)],res.rel,by=cc(model,par.type,i,j),fun.na.by=NULL,all.x=T,common.cols="drop.y")
       ,
        ext.nofix=mergeCheck(res.ext[!is.na(par.type)&FIX==0],res.rel,by=cc(model,par.type,i,j),fun.na.by=NULL,common.cols="drop.y")
       ,
        labs.all=mergeCheck(res.rel,res.ext[!is.na(par.type)],by=cc(model,par.type,i,j),fun.na.by=NULL,all.x=T,common.cols="drop.y")
    )

    expect_equal_to_reference(
        res
       ,
        fileRef
    )

    if(F){
        ref <- readRDS(fileRef)
        compareCols(ref$ext.nofix,   res$ext.nofix)

        expect_equal(
            res$ext.all$parameter
           ,
            ref$ext.all$parameter
        )

        expect_equal(
            head(res$labs.all)
           ,
            head(ref$labs.all)
        )

expect_equal(
            head(res$ext.nofix)
           ,
            head(ref$ext.nofix)
        )



        compareCols(
            res
           ,
            ref
                    )
    }
    
})


test_that("2 models",{

    file.mod <- c("testData/nonmem/xgxr032.mod",
                  "testData/nonmem/xgxr024.mod")

    fileRef <- "testReference/NMrelate_03.rds"

    res1 <- NMrelate(file=file.mod[1])
    res2 <- NMrelate(file=file.mod[2])
    res <- NMrelate(file=file.mod)

    expect_equal_to_reference(res,fileRef)

    ##    NMrelateOne(file.mod[2])

    if(F){
        ref <- readRDS(fileRef)
        ref
        res
}
})


test_that("lowercase",{
    file.mod <- "testData/nonmem/xgxr032.mod"
    file.mod.lower <- "testOutput/NMrelate_lowercase.mod"

    
    PK <- NMreadSection(file.mod,section="PK")
    PK <- gsub("THETA","theta",x=PK)
    PK <- gsub("([^H])ETA","\\1eta",x=PK)
    mod <- NMwriteSection(file.mod,section="PK",newlines=PK,
                          newfile = file.mod.lower)


    res1 <- NMrelate(file.mod,as.fun="data.table")
    res1.lower <- NMrelate(file.mod.lower,as.fun="data.table")

    res1[,model:=NULL]
    res1.lower[,code:=toupper(code)][
       ,model:=NULL]

    expect_equal(res1,res1.lower)
    
})
