% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_OLS.R
\name{.computeTuningParameters_OLS}
\alias{.computeTuningParameters_OLS}
\alias{print.NAVAE_CI_OLS_TuningParameters}
\title{Compute tuning parameters for the NAVAE confidence interval in the
linear regression case}
\usage{
.computeTuningParameters_OLS(n, a = NULL, omega = NULL)

\method{print}{NAVAE_CI_OLS_TuningParameters}(x, ...)
}
\arguments{
\item{n}{sample size}

\item{a}{parameter a in the function \code{\link{Navae_ci_ols}}}

\item{omega}{parameter omega in the function \code{\link{Navae_ci_ols}}}

\item{x}{object to be printed}

\item{...}{other arguments to passed to \code{print}, currently unused.}
}
\value{
\code{.computeTuningParameters_OLS} returns an object of class
\code{NAVAE_CI_OLS_TuningParameters} with the values of the tuning parameters
and some information on how they were determined.

\code{print} displays information about the tuning parameters and returns
\code{x} invisibly.
}
\description{
Compute tuning parameters for the NAVAE confidence interval in the
linear regression case
}
\examples{

.computeTuningParameters_OLS(n = 1000)
.computeTuningParameters_OLS(n = 1000, a = 2)
.computeTuningParameters_OLS(n = 1000, a = list(power_of_n_for_b = -1/3))
.computeTuningParameters_OLS(n = 1000, omega = 0.2)
.computeTuningParameters_OLS(n = 1000, omega = list(power_of_n_for_omega = -0.2))

}
