% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{rCFUSN}
\alias{rCFUSN}
\title{Random multivariate CFUSN}
\usage{
rCFUSN(n, Delta)
}
\arguments{
\item{n}{The number of variates to be generated}

\item{Delta}{Correlation matrix, the skewness matrix Delta}
}
\value{
A random matrix \eqn{n \times d}
}
\description{
Generate random d-vectors  from the multivariate
Canonical Fundamental Skew-Normal (CFUSN) distribution
}
\examples{
d <- 2; p <- 3
Lamd <-  matrix(sample(1:50-25, d*p), nrow=d)
ieg<- eigen(diag(p)+t(Lamd)\%*\%Lamd)
V <- ieg$vectors
Delta <-Lamd \%*\% V \%*\% diag(1/sqrt(ieg$values)) \%*\% t(V)
x<-rCFUSN(20,Delta)

}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (5.5) p.247

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Random generation: 
\code{\link{rCFUSSD}()},
\code{\link{rSkewNorm}()},
\code{\link{rUniS}()}
}
\concept{Random generation}
