% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{Mom2Cum}
\alias{Mom2Cum}
\title{Convert moments to cumulants (univariate and multivariate)}
\usage{
Mom2Cum(moments, Type = c("Univariate", "Multivariate"))
}
\arguments{
\item{moments}{Either a vector of univariate moments or a list of vectors of multivariate moments.}

\item{Type}{A character string specifying the type of moments provided. Use "Univariate" for univariate moments and "Multivariate" for multivariate moments.}
}
\value{
The vector of cumulants if \code{Type} is "Univariate" or the list of vectors of cumulants if \code{Type} is "Multivariate".
}
\description{
Obtains a vector of cumulants from a vector of moments for either univariate or multivariate data.
}
\examples{
# Univariate example
mu_x <- c(1, 2, 3, 4)
Mom2Cum(mu_x, Type = "Univariate")

# Multivariate example
mu <- list(c(0,0), c(1,0,0,1), c(0,0,0,0,0,0,0,0), c(3,0,0,1,0,1,1,0,0,1,1,0,1,0,0,3), c(rep(0,32)))
Mom2Cum(mu, Type = "Multivariate")

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear, Springer 2021. Section 3.4.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
