% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mean_impute}
\alias{mean_impute}
\title{Mean Imputation}
\usage{
mean_impute(X)
}
\arguments{
\item{X}{An \eqn{n} x \eqn{d} matrix or data frame where \eqn{n} is the number of
observations and \eqn{d} is the number of columns or variables. Alternately,
\code{X} can be a vector of \eqn{n} observations.}
}
\value{
A complete data matrix with missing values imputed accordingly.
}
\description{
Replace missing values of data set by the mean of other observed values.
}
\examples{

X <- matrix(nrow = 6, ncol = 3, byrow = TRUE, c(
  NA,  2,  2,
   3, NA,  5,
   4,  3,  2,
  NA, NA,  3,
   7,  2, NA,
  NA,  4,  2
))


mean_impute(X)

}
\references{
Schafer, J. L. and Graham, J. W. (2002). Missing data: our view of the state of the art.
  \emph{Psychological Methods}, 7(2):147–177.  \cr \cr
Little, R. J. A. and Rubin, D. B. (2020). \emph{Statistical analysis with missing data}.
  Wiley Series in Probability and Statistics. Wiley, Hoboken, NJ, 3rd edition
}
