% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.codes.R
\name{Classify.vis}
\alias{Classify.vis}
\title{Visualize Microbial Feature Classification Results Using NMDS}
\usage{
Classify.vis(
  classified_results,
  dist_method = "bray",
  fig_title = "NMDS visualization",
  legd_title = "Predicted Groups",
  points_size = 1,
  legend_title_size = 8,
  legend_text_size = 6,
  axis_title_size = 6,
  axis_text_size = 6
)
}
\arguments{
\item{classified_results}{A list object of \code{\link[MicrobTiSDA]{Data.rf.classifier}} output.}

\item{dist_method}{Dissimilarity index, defaults to \code{bray}. For other options, including
\code{manhattan}, \code{euclidean}, \code{canberra} etc., see \code{\link[vegan]{vegdist}}.}

\item{fig_title}{A character string specifying the title of the NMDS plot. Default is \code{'NMDS visualization'}.}

\item{legd_title}{A character string for the legend title representing the predicted groups. Default is \code{'Predicted Groups'}.}

\item{points_size}{A numeric value specifying the size of the points in the plot. Default is \code{1}.}

\item{legend_title_size}{A numeric value specifying the font size of the legend title. Default is \code{8}.}

\item{legend_text_size}{A numeric value specifying the font size of the legend text. Default is \code{6}.}

\item{axis_title_size}{A numeric value specifying the font size of the axis titles. Default is \code{6}.}

\item{axis_text_size}{A numeric value specifying the font size of the axis text. Default is \code{6}.}
}
\value{
A \code{ggplot2} object displaying the NMDS plot with samples colored by their predicted group and convex hulls
outlining each group.
}
\description{
This function generates a non-metric multidimensional scaling (NMDS) plot to visualize OTU/ASV classification
results. It combines an OTU/ASV table with predicted group labels to produce a scatter plot in NMDS space,
where each sample is colored according to its predicted group.
}
\details{
The function expects as input the results of output of the function \code{\link[MicrobTiSDA]{Data.rf.classifier}}.
It conputes NMDS coordinates based on the OTU/ASV data using the specified distance method (defaulting to
Bray-Curtis) and then maps the predicted group labels onto the NMDS coordinates. The visualization is produced
using \code{ggplot2}, with polygons delineating the convex hull of each predicted group.
}
\examples{
\donttest{
# Example OTU count data (20 OTUs x 10 samples)
set.seed(123)
otu_data <- matrix(sample(0:100, 200, replace = TRUE), nrow = 20)
colnames(otu_data) <- paste0("Sample", 1:10)
rownames(otu_data) <- paste0("OTU", 1:20)

# Example metadata with group labels
metadata <- data.frame(Group = rep(c("Control", "Treatment"), each = 5))

# Run the classifier
rf_result <- Data.rf.classifier(raw_data = otu_data,
                             metadata = metadata,
                             train_p = 0.7,
                             Group = "Group",
                             OTU_counts_filter_value = 50)
# If you wish to select the top 5 features:
result <- Rf.biomarkers(rf = rf_result, feature_select_num = 5)

nm_plot <- Classify.vis(classified_results = result,
                        dist_method = 'bray',
                        fig_title = 'NMDS Plot',
                        legd_title = 'Predicted Groups',
                        points_size = 1.5)
}

}
\author{
Shijia Li
}
