% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GridSearch.R
\name{GridSearch}
\alias{GridSearch}
\title{GridSearch searched over a list of interval width and overlap,
useful for visualizing the convergence of the Mapper.}
\usage{
GridSearch(
  original_data,
  filter_values,
  label,
  column = "label",
  cover_type = "stride",
  width_vec = c(0.5, 1, 1.5),
  overlap_vec = c(10, 20, 30, 40),
  num_cores = 12,
  out_dir = "mapper_grid_outputs",
  avg = FALSE,
  use_embedding = NULL
)
}
\arguments{
\item{original_data}{Original dataframe, not the filter values.}

\item{filter_values}{A numeric matrix or data frame of filter values (rows are samples, columns are filter dimensions).}

\item{label}{A vector of labels for coloring the Mapper nodes.}

\item{column}{The original column name (use when use_embedding=TRUE).}

\item{cover_type}{The type of cover to use "stride" or "extension".}

\item{width_vec}{A vector of interval widths.}

\item{overlap_vec}{A vector of percent overlaps.}

\item{num_cores}{Number of cores to use for parallel computing.}

\item{out_dir}{Directory to save the output.}

\item{avg}{Whether coloring the nodes by average label or majority label.}

\item{use_embedding}{Whether to use embedding for coloring (NULL or embedding vector).}
}
\value{
A folder containing the PNG files of the Mapper visualizations.
}
\description{
GridSearch searched over a list of interval width and overlap,
useful for visualizing the convergence of the Mapper.
}
