% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.mff.R
\name{tune.mff}
\alias{tune.mff}
\title{Hyperparameter Search for Meta-Fuzzy Function}
\usage{
tune.mff(
  x,
  y,
  max_c,
  m_seq = seq(1.1, 3, by = 0.1),
  eta_seq = seq(1.1, 3, by = 0.4),
  iter.max = 1000,
  nstart = 100,
  seed = 123,
  mff.method = c("fcm", "pfcm", "kmeans"),
  eval.method = c("MAE", "RMSE", "MAPE", "SMAPE", "MSE", "MedAE"),
  logging = TRUE
)
}
\arguments{
\item{x}{A numeric matrix of base-model predictions with dimensions \eqn{N_{test} \times M}. Each
column corresponds to a base learner.}

\item{y}{numeric vector of validation targets. This vector is used to evaluate meta fuzzy function
predictions.}

\item{max_c}{An integer specifying the maximum number of clusters to be considered in the
search.}

\item{m_seq}{A numeric vector of candidate values for the fuzziness exponent m used in FCM-
type methods.}

\item{eta_seq}{A numeric vector of candidate values for the probabilistic regularization parameter
\eqn{\eta}{eta} used when mff.method = "pfcm".}

\item{iter.max}{An integer specifying the maximum number of iterations allowed for the clustering
algorithm within each grid evaluation..}

\item{nstart}{integer; An integer controlling the number of random initializations for k-means
when mff.method = "kmeans".}

\item{seed}{An integer used to set the random seed for reproducibility during weight computation
and parameter search.}

\item{mff.method}{A character string selecting the membership-generation method.}

\item{eval.method}{A character string specifying the metric used to select the best-performing
meta fuzzy function.}

\item{logging}{A logical flag indicating whether progress information is printed during the search.}
}
\value{
\itemize{
\item \code{algorithm}: The selected membership-generation method.
\item \code{eval.method}: The evaluation metric used in model selection.
\item \code{weights}: The membership (weight) matrix associated with the best-performing
configuration.
\item \code{best_params}: A list containing the hyperparameters that achieved the best score.
\item \code{best_cluster}: The index of the meta fuzzy function yielding the minimum validation error.
\item \code{best_weight}: The weight vector corresponding to the best-performing meta fuzzy function.
\item \code{best_scores}: The full set of evaluation scores for all meta fuzzy function predictions under
the best configuration.
}
}
\description{
The \emph{tune.mff} function performs hyperparameter optimization via grid search for Meta Fuzzy Functions
(MFFs) by searching over clustering-related parameter combinations and selecting the configuration that
yields the lowest validation error.
}
\details{
Given a matrix of base-model predictions and the corresponding validation targets, \emph{tune.mff}
repeatedly calls \emph{mff} to compute membership weights, generate meta fuzzy function
predictions, and evaluate these predictions using a user-specified metric. The best
configuration is determined by the minimum value of the selected evaluation metric among
the scores obtained from the meta fuzzy function predictions produced under each candidate
setting.

The search space depends on the selected membership-generation method. For classical Fuzzy
C-Means ("fcm"), the function explores combinations of the number of clusters c and the fuzziness index m. For possibilistic FCM ("pfcm"), the
grid additionally includes the possibilistic regularization parameter \eqn{\eta}{eta}. For k-means
("kmeans"), the search is performed only over the number of clusters(c). The function returns
the best-performing configuration together with the corresponding weight structure, the index
of the best-performing meta fuzzy function, and the full set of evaluation results, enabling
transparent reporting and reproducible model selection.
}
\examples{
  res <- model.train(target="medv", data=MASS::Boston, ntest=50, nvalid=50, seed = 123)
  fit <- tune.mff(res$pred_matrix_valid, res$y_valid, max_c=6, mff.method="kmeans")
  out <- predict(fit, pred_matrix=res$pred_matrix_test, type="best")
  head(out$mff_preds)
  out$mff_weights


}
\seealso{
\code{\link{mff}}, \code{\link{model.train}}, \code{\link{predict.mff}}
}
