% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_power.R
\name{hybrid_power}
\alias{hybrid_power}
\title{Power Estimation for the multivariate goodness-of-fit problem via twosample tests}
\usage{
hybrid_power(
  rnull,
  ralt,
  param_alt,
  phat = function(x) -99,
  nMC = 1,
  TS,
  TSextra,
  With.p.value = FALSE,
  alpha = 0.05,
  B = 1000,
  maxProcessor,
  doMethods = "all"
)
}
\arguments{
\item{rnull}{routine to generate data under the null hypothesis.}

\item{ralt}{routine to generate data under the alternative hypothesis.}

\item{param_alt}{values passed to ralt.}

\item{phat}{=function(x) -99 parameter estimation, if needed.}

\item{nMC}{=1 sample size of Monte Carlo data set, if it is a number nMC<=10  sample size used will be nMC*sample size of x.}

\item{TS}{user supplied function to find test statistics, if any.}

\item{TSextra}{(optional) list passed to TS, if needed.}

\item{With.p.value}{=FALSE, does user supplied method find its own p-values?}

\item{alpha}{=0.05 type I error rate used in tests.}

\item{B}{=5000  number of simulation runs. If B=0 the routine returns the test statistics.}

\item{maxProcessor}{number of processors to use in parallel processing.}

\item{doMethods}{="all", a vector of codes for the methods to include or all of them.}
}
\value{
A list with vectors of test statistics and p.values
}
\description{
This function estimates the power of goodness-of-fit/two-sample hybrid tests using Rcpp and parallel computing
by generating a Monte Carlo data set and then running a twosample test.
}
\details{
For details on the usage of this routine consult the vignette with vignette("MDgof-hybrid","MDgof-hybrid")
}
\examples{
# All examples are run with B=20 and maxProcessor=1 to pass CRAN checks.
# Power of tests see whether data comes from a bivariate standard normal distribution, 
# without parameter estimation. True Distribution is bivariate normal with
# correlation r.
rnull=function() mvtnorm::rmvnorm(100, c(0, 0))
ralt=function(r) mvtnorm::rmvnorm(100, sigma=matrix(c(1,r,r,1),2,2))
hybrid_power(rnull, ralt, 0.3, B=20, maxProcessor = 1)
# Power of tests to see whether data comes from a standard normal distribution, 
# with mean parameter estimated. True data comes from t distribution.
rnull=function(p) mvtnorm::rmvnorm(100, p)
ralt=function(df) mvtnorm::rmvt(100, df=df)
phat=function(x) apply(x, 2, mean)  
hybrid_power(rnull, ralt, 5, phat, B=20, maxProcessor = 1)
}
