% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.logreg2.R
\name{predict.logreg2}
\alias{predict.logreg2}
\title{Predict Method for Logic Regression Objects (Internal)}
\usage{
\method{predict}{logreg2}(object, msz, ntr, newbin, newsep, newcens, ...)
}
\arguments{
\item{object}{An object of class \code{"logreg"}.}

\item{msz}{Integer. Maximum number of leaves in a tree.}

\item{ntr}{Integer. Number of trees in \code{object}.}

\item{newbin}{Matrix containing binary predictor values for new data points.}

\item{newsep}{Integer. Number of separate predictors in \code{newbin}.}

\item{newcens}{Vector. Censoring indicator for survival data (if applicable).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A numeric vector or matrix of predictions.
}
\description{
INTERNAL FUNCTION: evaluates the importance of predictor combinations and
generates predictions from a fitted logic regression object.
}
\details{
This function is typically called internally by other functions and is not
intended for direct use by package users.

Depending on the model type (\code{object$type}), this function produces:
\itemize{
\item Classification predictions (0/1) if \code{type == "classification"}.
\item Predicted probabilities if \code{type == "logistic"}.
\item Survival model predictions if \code{type == "proportional.hazards"}.
}
}
\keyword{internal}
