% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huntlam_calib.R
\name{huntlam.calib}
\alias{huntlam.calib}
\title{Bayesian Classical Linear Calibration Function}
\usage{
huntlam.calib(x, y, alpha, y0)
}
\arguments{
\item{x}{numerical vector of regressor measurments}

\item{y}{numerical vector of observation measurements}

\item{alpha}{the confidence interval to be calculated}

\item{y0}{vector of observed calibration value}
}
\description{
\code{huntlam.calib} uses the classical Bayesian approach to estimate an unknown X given observed vector y0 and calculates credible interval estimates.
}
\examples{
X <- c(1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10)
Y <- c(1.8,1.6,3.1,2.6,3.6,3.4,4.9,4.2,6.0,5.9,6.8,6.9,8.2,7.3,8.8,8.5,9.5,9.5,10.6,10.6)

huntlam.calib(X,Y,0.05,6)
}
\references{
Hunter, W., and Lamboy, W. (1981). A Bayesian Analysis of the Linear Calibration Problem. Technometrics. 3, 323-328.
}
\keyword{calibration}
\keyword{linear}
