% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beta_correction_plot_functions.R
\name{overall_correction}
\alias{overall_correction}
\title{Plot Overall Corrections from Booster Component}
\usage{
overall_correction(transform_x_scale_by_link = TRUE)
}
\arguments{
\item{transform_x_scale_by_link}{TRUE/FALSE, whether to transform the x axis by the link function}
}
\value{
A ggplot2 object.
}
\description{
Creates a visualization showing for each record the overall booster component (either multiplicative or additive)

\strong{NOTE} This function signature documents the interface of functions created by \code{\link{create_overall_correction}}.
}
\examples{
# This function is created inside explain_iblm() and is output as an item

df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

explain_objects <- explain_iblm(iblm_model, df_list$test)

explain_objects$overall_correction()


# This function must be created, and cannot be called directly from the package
try(
overall_correction()
)
}
\seealso{
\code{\link{create_overall_correction}}, \code{\link{explain_iblm}}
}
