% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beta_correction_plot_functions.R
\name{create_beta_corrected_density}
\alias{create_beta_corrected_density}
\title{Create Pre-Configured Beta Corrected Density Plot Function}
\usage{
create_beta_corrected_density(
  wide_input_frame,
  beta_corrections,
  data,
  iblm_model
)
}
\arguments{
\item{wide_input_frame}{Dataframe. Wide format input data (one-hot encoded).}

\item{beta_corrections}{Dataframe. Output from \code{\link{beta_corrections_derive}}.}

\item{data}{Dataframe. The testing data.}

\item{iblm_model}{Object of class 'iblm'.}
}
\value{
Function with signature \code{function(varname, q = 0.05, type = "kde")}.
}
\description{
Factory function that returns a plotting function with data pre-configured.
}
\examples{
# ------- prepare iblm objects required -------

df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

test_data <- df_list$test
shap <- extract_booster_shap(iblm_model$booster_model, test_data)
wide_input_frame <- data_to_onehot(test_data, iblm_model)
shap_wide <- shap_to_onehot(shap, wide_input_frame, iblm_model)
beta_corrections <- beta_corrections_derive(shap_wide, wide_input_frame, iblm_model)

# ------- demonstration of functionality -------

# create_beta_corrected_density() can create function of type 'beta_corrected_density'
my_beta_corrected_density <- create_beta_corrected_density(
  wide_input_frame,
  beta_corrections,
  test_data,
  iblm_model
)

# this custom function then acts as per beta_corrected_density()
my_beta_corrected_density(varname = "VehAge")

}
\seealso{
[beta_corrected_density()]
}
