% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePredictedValues.R,
%   R/computePredictedValuesParallel.R
\name{computePredictedValues}
\alias{computePredictedValues}
\alias{pcomputePredictedValues}
\title{computePredictedValues}
\usage{
computePredictedValues(
  hM,
  partition = NULL,
  partition.sp = NULL,
  start = 1,
  thin = 1,
  Yc = NULL,
  mcmcStep = 1,
  expected = TRUE,
  initPar = NULL,
  nParallel = 1,
  nChains = length(hM$postList),
  updater = list(),
  verbose = hM$verbose,
  alignPost = TRUE
)

pcomputePredictedValues(
  hM,
  partition = NULL,
  partition.sp = NULL,
  start = 1,
  thin = 1,
  Yc = NULL,
  mcmcStep = 1,
  expected = TRUE,
  initPar = NULL,
  nParallel = 1,
  useSocket = .Platform$OS.type == "windows",
  nChains = length(hM$postList),
  updater = list(),
  verbose = nParallel == 1,
  alignPost = TRUE
)
}
\arguments{
\item{hM}{a fitted \code{Hmsc} model object}

\item{partition}{partition vector for cross-validation created by \code{\link{createPartition}}}

\item{partition.sp}{species partitioning vector for conditional cross-validation}

\item{start}{index of first MCMC sample included}

\item{thin}{thinning interval of posterior distribution}

\item{Yc}{response matrix on which the predictions are to be conditioned}

\item{mcmcStep}{number of MCMC steps used to make conditional predictions}

\item{expected}{whether expected values (TRUE) or realizations (FALSE) are to be predicted}

\item{initPar}{a named list of parameter values used for initialization of MCMC states}

\item{nParallel}{number of parallel processes by which the chains are executed}

\item{nChains}{number of independent MCMC chains to be run}

\item{updater}{a named list, specifying which conditional updaters should be omitted}

\item{verbose}{the interval between MCMC steps printed to the console}

\item{alignPost}{boolean flag indicating whether the posterior of each chains should be aligned}

\item{useSocket}{(logical) use socket clusters in parallel processing;
these can be used in all operating systems, but they are
usually slower than forking which can only be used
in non-Windows operating systems (macOS, Linux, unix-like
systems).}
}
\value{
an array of model predictions, made for each posterior sample
}
\description{
Computes predicted values from the fitted \code{Hmsc} model
}
\details{
There are two alternative functions \code{computePredictedValues}
and \code{pcomputePredictedValues}. Function
\code{pcomputePredictedValues} uses more aggressive parallelization
and can be much faster when \code{partition} is used. Function
\code{computePredictedValues} can run chains of each
\code{sampleMcmc} partition in parallel, but
\code{pcomputePredictedValues} can run each partition fold times
chain in parallel (if hardware and operating systems
permit). Function \code{pcomputePredictedValues} is still
experimental, and therefore we provide both the old and new
functions, but the old functions is scheduled to be removed in the
future. Species partitions are not yet parallelized, and they can
be very slow, especially with many \code{mcmcSteps}.

If the option \code{partition} is not used, the posterior predictive distribution is based on the model
fitted to the full data. If the option \code{partition} is used but \code{partition.sp} is not used, the posterior predictive distribution
is based on cross-validation over the sampling units. If \code{partition.sp} is additionally used, then, when predictions are made for
each fold of the sampling units, the predictions are done separately for each fold of species. When making the predictions
for one fold of species, the predictions are conditional on known occurrences (those observed in the data) of the species
belonging to the other folds. If \code{partition.sp} is used, the parameter \code{mcmcStep} should be set high enough to obtain
appropriate conditional predictions. The option \code{Yc} can be used alternatively to \code{partition.sp} if the conditioning is to be done
based on a fixed set of data (independently of which sampling unit and species the predictions are made for).
}
\examples{
# Compute predicted values using a previously fitted HMSC model
preds = computePredictedValues(TD$m)

\dontrun{
# Compute predicted values for a previously fitted HMSC model using 2 folds
partition = createPartition(TD$m, nfolds = 2)
predsCV1 = computePredictedValues(TD$m,partition=partition)

# Compute conditional predictions for a previously fitted HMSC model using 2 folds
partition = createPartition(TD$m, nfolds = 2)
predsCV2 = computePredictedValues(TD$m, partition = partition,
partition.sp = 1:TD$m$ns, mcmcStep = 100)
}

}
\seealso{
\code{\link{predict.Hmsc}}
}
