% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{visualizeModule}
\alias{visualizeModule}
\title{Visualization of module}
\usage{
visualizeModule(
  hicpath,
  HC.object,
  moduleNum,
  resolution,
  hic.norm,
  heatmap.color.range = NULL,
  heatmap.color = colorRampPalette(c("white", "red")),
  arc.depth = 10,
  arc.color = "gray80",
  nbnom.param = 0.99,
  txdb = "TxDb.Mmusculus.UCSC.mm10.knownGene",
  gene.strand.arrow.lwd = 3,
  gene.strand.lwd = 6,
  col.forward.gene = "purple",
  col.reverse.gene = "pink",
  highlight.centrality = FALSE,
  highlight.cent.col = FALSE,
  highlight.node = NULL,
  highlight.node.col = NULL,
  show.sig.int = TRUE,
  netinfo
)
}
\arguments{
\item{hicpath}{Path to the .hic file}

\item{HC.object}{The object name from hic2community result}

\item{moduleNum}{The row index of module to draw}

\item{resolution}{Resolution of HiC data}

\item{hic.norm}{Normalization method. If not, set 'NONE'}

\item{heatmap.color.range}{Min and max value of contact frequency, e.g., c(0,10)}

\item{heatmap.color}{Color for heatmap. For example, colorRampPalette(c("white","red))}

\item{arc.depth}{Height of arc plot}

\item{arc.color}{Arc color}

\item{nbnom.param}{Negative binomial probability cutoff. Higher cutoff gives less number of arcs.}

\item{txdb}{Character. One of Txdb list obtained from get_txdb().}

\item{gene.strand.arrow.lwd}{Numeric. Line width of arrowhead indicating the strands of genes. Same as arr.lwd option in Arrows function in shape package.}

\item{gene.strand.lwd}{Numeric. Line width of arrow body indicating the strands of genes. Same as lwd option in Arros function in shape package.}

\item{col.forward.gene}{Character. Color of arrows within gene track for forward genes.}

\item{col.reverse.gene}{Character. Color of arrows within gene track for reverse genes}

\item{highlight.centrality}{Boolean input to set if highlight eigenvector centrality node.}

\item{highlight.cent.col}{The color of arcs stemming from the centrality node.}

\item{highlight.node}{The coordiante of a node of which the user will highlight the arcs stemming from this node. Default=NULL}

\item{highlight.node.col}{The color of arcs stemming from the node which the user highlight.}

\item{show.sig.int}{Boolean. If TRUE, it marks significant contact on the triangle heatmap.}

\item{netinfo}{Boolean. If TRUE, it shows network information of the module as text in the plot.}
}
\value{
No return value; the function generates a plot.
}
\description{
It draws a triangle heatmap and arcplot of a module
}
\details{
Visualization of module
}
\examples{
# A slow example that takes too long to run, wrapped in donttest{}
\donttest{
myhic = system.file('extdata','example.hic',package = 'HiCocietyExample')
HC.object = hic2community(myhic, "19", 5000, 0.975, 2000000, par.noise=1,
'louvain', n_cores=2)
mNum = 1
visualizeModule(hicpath = myhic, HC.object = HC.object, moduleNum = mNum,
resolution = 5000,
hic.norm = 'NONE', heatmap.color.range=c(0,10),
heatmap.color = colorRampPalette(c('white','red')),
arc.depth=10, arc.color = "gray80", nbnom.param=0.99,
txdb = 'TxDb.Mmusculus.UCSC.mm10.knownGene',
gene.strand.arrow.lwd = 3, gene.strand.lwd = 3,
col.forward.gene = 'purple', col.reverse.gene = 'pink',
highlight.centrality=FALSE, highlight.cent.col=FALSE,
highlight.node=NULL, highlight.node.col=NULL,
show.sig.int=FALSE, netinfo=FALSE)
}
}
\author{
Sora Yoon, PhD
}
