\name{generateHMM}
\alias{generateHMM}
\title{Generate Data from a Hidden Markov Model}
\description{
Simulates observations and hidden states from a Hidden Markov Model (HMM) with specified observation distributions.
}
\usage{
generateHMM(n, J, obsdist, obspar, Pi, delta = NULL, seed = NULL)
}
\arguments{
\item{n}{Integer. The number of observations to generate.}
\item{J}{Integer. The number of hidden states in the model.}
\item{obsdist}{Character string. The observation distribution. Supported distributions are: "norm", "pois", "weibull", "zip", "nbinom", "zinb", "exp", "gamma", "lnorm", "gev", "ZInormal", "ZIgamma".}
\item{obspar}{List. Parameters for the observation distribution. Required parameters vary by distribution:
  \itemize{
    \item \code{norm}: \code{mean}, \code{sd}
    \item \code{pois}: \code{lambda}
    \item \code{weibull}: \code{shape}, \code{scale}
    \item \code{zip}: \code{pi}, \code{lambda}
    \item \code{nbinom}: \code{size}, \code{mu}
    \item \code{zinb}: \code{pi}, \code{size}, \code{mu}
    \item \code{exp}: \code{rate}
    \item \code{gamma}: \code{shape}, \code{rate}
    \item \code{lnorm}: \code{meanlog}, \code{sdlog}
    \item \code{gev}: \code{loc}, \code{scale}, \code{shape}
    \item \code{ZInormal}: \code{mean}, \code{sd}, \code{pi}
    \item \code{ZIgamma}: \code{shape}, \code{rate}, \code{pi}
  }
  Each parameter should be a vector of length \code{J} with values for each state.
}
\item{Pi}{Matrix. The \code{J x J} transition probability matrix between states. Rows must sum to 1.}
\item{delta}{Numeric vector of length \code{J}. The initial state distribution. If \code{NULL}, the stationary distribution is computed from \code{Pi}.}
\item{seed}{Integer or \code{NULL}. Random seed for reproducibility. Default is \code{NULL}.}
}
\value{
A list containing:
\item{x}{Numeric vector of the simulated observations.}
\item{state}{Numeric vector of the simulated hidden state sequence.}
}
\details{
This function simulates data from a Hidden Markov Model where:
\itemize{
  \item Hidden states follow a discrete-time Markov chain with transition matrix \code{Pi}
  \item At each time step, observations are generated from state-dependent distributions
}
The function supports multiple observation distributions including normal, Poisson, Weibull, zero-inflated Poisson (ZIP), negative binomial, zero-inflated negative binomial (ZINB), exponential, gamma, log-normal, generalized extreme value (GEV), zero-inflated normal, and zero-inflated gamma.
The initial state is sampled according to the initial distribution \code{delta}. If \code{delta} is not provided, it is computed as the stationary distribution of the Markov chain defined by \code{Pi}.
}
\examples{
# Example with 3 states, normal observations
J <- 3
# HMM transition matrix
Pi <- matrix(c(0.8, 0.15, 0.05,
               0.1, 0.7,  0.2,
               0.2, 0.3,  0.5), nrow = 3, byrow = TRUE)
# Observation parameters (normal distribution)
obspar <- list(
  mean = c(-2, 0, 3),
  sd = c(0.5, 1, 1.5)
)
# Generate 200 observations
sim_data <- generateHMM(n = 200, J = J, obsdist = "norm",
                       obspar = obspar, Pi = Pi)
# View the results
head(sim_data$x)      # observations
head(sim_data$state)  # hidden states
length(sim_data$x)    # number of observations
}
\seealso{
\code{\link{generateHSMM}} for Hidden Semi-Markov Models.
}
\author{
[Aimee Cody]
}

