% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{HCR.fast}
\alias{HCR.fast}
\title{The Fast Version for Fitting Hidden Compact Representation Model}
\usage{
HCR.fast(X, Y, score_type = "bic", ...)
}
\arguments{
\item{X}{The data of cause.}

\item{Y}{The data of effect.}

\item{score_type}{You can choose "bic","aic","aicc","log" as the type of score to fit the HCR model. Default: bic}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
The fitted HCR model and its score.
}
\description{
A fast implementation for fitting the HCR model.
This implementation caches all intermediate results to speed up the greedy search.
The basic idea is that if there are two categories need to be combined, for instance, X=1 and X=2 mapping to the same Y'=1, then the change of the score only depend on the frequency of the data where X=1 and X=2.
Therefore, after combination, if the increment of the likelihood is greater than the penalty, then we will admit such combination.
}
\examples{
library(data.table)
set.seed(1)
data=simuXY(sample_size=2000)
r1=HCR.fast(data$X,data$Y)
r2=HCR.fast(data$Y,data$X)
# The canonical hidden representation
unique(r1$data[,c("X","Yp")])
# The recovery of hidden representation
unique(data.frame(data$X,data$Yp))

}
