% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmultparallel.R
\name{plot.parallel_Kmult}
\alias{plot.parallel_Kmult}
\title{Plot method for parallel_Kmult objects}
\usage{
\method{plot}{parallel_Kmult}(x, alpha = 0.25, title = NULL, x_lab = "Kmult", ...)
}
\arguments{
\item{x}{An object of class 'parallel_Kmult' produced by
\code{\link{Kmultparallel}}}

\item{alpha}{Transparency level for density plots (0-1,
default = 0.25)}

\item{title}{Character string for plot title (default NULL for
automatic title)}

\item{x_lab}{Character string for x-axis label (default "Kmult")}

\item{...}{Additional arguments passed to the plotting function}
}
\value{
A ggplot object
}
\description{
Creates density plots of Kmult values, with separate densities for
each combination of dataset and treeset (if multiple combinations are
present).
}
\examples{
\donttest{
# Create simple example data
library(phytools)
trees = replicate(5, pbtree(n = 20), simplify = FALSE)
class(trees) = "multiPhylo"
data = matrix(rnorm(20 * 4), nrow = 20, ncol = 4)
rownames(data) = trees[[1]]$tip.label

# Run analysis and plot results
result = Kmultparallel(data, trees)
plot(result)

# With custom settings
plot(result, alpha = 0.5, title = "Kmult Distribution")
}

}
