param_hier_ward <-
function(x, k){
  
  hc <- hclust(dist(x), method = "ward.D")
  
  cluster <- cutree(hc, k)
  
  
  mu_init <- matrix(0, nrow = k, ncol = ncol(x))
  for (i in 1:k) {
    mu_init[i, ] <- colMeans(x[cluster == i, , drop = FALSE])
  }
  
  
  p <- ncol(x)  
  sigma_init <- array(0, dim = c(p, p, k)) 
  
  for (i in 1:k) {
    cluster_data <- x[cluster == i, , drop = FALSE]
    sigma_init[ , , i] <- cov(cluster_data)  
  }
  
  
  pi_k <- as.numeric(  table(cluster) / nrow(x))
  
  return(list( pi_k = pi_k, mu = mu_init, sigma = sigma_init))
  
  
}
