% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{quagev.NS}
\alias{quagev.NS}
\title{Quantile function for non-stationary GEV models}
\usage{
quagev.NS(f = NULL, para = NULL, nsample = NULL, model = NULL)
}
\arguments{
\item{f}{Probability (or vector of probabilities) for quantile calculation.}

\item{para}{Parameter vector. For GEV11: (mu0, mu1, sigma0, sigma1, xi).}

\item{nsample}{Number of time points (sample size).}

\item{model}{Model type: "gev11", "gev10", "gev20", "gev01", or "gev00"/"gev".}
}
\value{
A matrix of quantiles (nsample x length(f)) or a vector if f is scalar.
}
\description{
Calculates quantiles for non-stationary GEV models including GEV11,
GEV10, GEV20, and stationary GEV00.
}
\examples{
# GEV11 model: time-varying quantiles
para <- c(84.55, 1.03, 2.91, 0.009, -0.08)  # mu0, mu1, sigma0, sigma1, xi
q99 <- quagev.NS(f = 0.99, para = para, nsample = 53, model = "gev11")
print(q99)

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}
}
\seealso{
\code{\link{glme.gev11}} for non-stationary GEV estimation,
  \code{\link{glme.gev}} for stationary GEV estimation.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
