% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_periods.R
\name{create_event_mapping}
\alias{create_event_mapping}
\title{Create Event Mapping}
\usage{
create_event_mapping(events, start_time, end_time, max_row_number)
}
\arguments{
\item{events}{Data frame containing the start and end index of each event.}

\item{start_time}{Name of the column in events containing the start index of the events.}

\item{end_time}{Name of the column in events containing the end index of the events.}

\item{max_row_number}{Number of rows in the source vector the events describe}
}
\value{
List of mapped events.
}
\description{
Create Event Mapping
}
\details{
Enumerate a vector to identify which event each measurement belongs to.
}
\examples{
events <- data.frame(
  "start" = c(1, 5, 10, 15),
  "end" = c(4, 9, 14, 19)
)
time_series <- rnorm(25)
period_number <- create_event_mapping(events, "start", "end", length(time_series))
}
