% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetCen.R
\name{NetCen}
\alias{NetCen}
\title{Compute the centrality metrics for the nodes composing the network generated by the NetVis function}
\usage{
NetCen(data, g1, g2)
}
\arguments{
\item{data}{A data frame containing the relationship between the two groups to be represented in the network}

\item{g1}{Name of the column containing the labels of the first group that will be used to create the network}

\item{g2}{Name of the column containing the labels of the second group that will be used to create the network}
}
\value{
A data frame with the centrality metrics for each node in the network.
}
\description{
Compute the centrality metrics for the nodes composing the network generated by the NetVis function
}
\details{
This function returns the following centrality metrics for each node that composed the network: Degree (The number of edges incident to the node), Betweenness (The fraction of shortest paths between pairs of nodes that pass through the node), Closeness (The inverse of the sum of the shortest path distances from the node to all other nodes), and Eigenvector Centrality (The centrality measure based on the eigenvector of the adjacency matrix).
}
