% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_k_clustering.R
\name{k_clustering}
\alias{k_clustering}
\title{Perform k-means}
\usage{
k_clustering(
  kmeans_data,
  standardise = TRUE,
  k,
  nstart = 50,
  polygon = FALSE,
  output = TRUE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{kmeans_data}{Data frame containing the combined PC scores and depth
statistics to perform k-means on. Output from the 'combine_data()'
function.}

\item{standardise}{TRUE or FALSE. Whether or not to standardise the data.
Defaults to TRUE.}

\item{k}{Numerical. Value of k to use for analysis.}

\item{nstart}{Numerical. Value of nstart for k-means analysis.}

\item{polygon}{TRUE or FALSE. Plot polygons for cluster with more than 3 data
points. Defaults to FALSE.}

\item{output}{TRUE or FALSE. Whether or not to output the results.
Defaults to TRUE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
An object of class 'kmeans' containing the k-means clustering data
for the data frame. Additionally plots a 3D cluster plot of the top three
Principal Components.
}
\description{
\code{k_clustering} performs k-means clustering on the PC scores with the selected
value of k
}
\details{
This function relies on random initialisation in k-means clustering.
For reproducible results, users may wish to set a random seed
prior to calling this function using \code{set.seed()}.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load kmeans_data
kmeans_data <- readRDS(file.path(filepath, "data/5_k-means/combined_stats.rds"))

\donttest{
# Full example using the complete dataset.
# Set output to TRUE for real use!

kmeans_result <- k_clustering(
  kmeans_data = kmeans_data,
  standardise = TRUE,
  k = 4,
  nstart = 50,
  polygon = FALSE,
  output = FALSE,
  output_folder = tempdir(),
  verbose = TRUE
)
}

}
