% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_swap_functions.R
\name{swap_pairs}
\alias{swap_pairs}
\title{Swap pairs in a matrix of integers}
\usage{
swap_pairs(
  X,
  starting_dist = 3,
  stop_iter = 10,
  lambda = 0.5,
  dist_method = "euclidean",
  candidate_sample_size = 4
)
}
\arguments{
\item{X}{A matrix of integers.}

\item{starting_dist}{The minimum starting distance to enforce between pairs of occurrences of the same integer. Default is 3.}

\item{stop_iter}{The maximum number of iterations to perform. Default is 50.}

\item{lambda}{A tuning parameter for the centrality penalty. Default is 0.1.}

\item{dist_method}{The method used for distance calculation. Options are "euclidean" (default) and "manhattan".}

\item{candidate_sample_size}{Maximum number of candidate cells to evaluate per swap. Default is 5.}
}
\value{
A list containing:
\item{optim_design}{The modified matrix.}
\item{designs}{A list of all intermediate designs, starting from the input matrix.}
\item{distances}{A list of all pair distances for each intermediate design.}
\item{min_distance}{The minimum distance between pairs of occurrences of the same integer in the final design.}
\item{pairwise_distance}{A data frame with the pairwise distances for the final design.}
\item{rows_incidence}{A vector recording the number of rows with repeated integers for each iteration.}
}
\description{
Modifies the input matrix \code{X} to ensure that the distance between any two occurrences
of the same integer is at least a distance \code{d}, by swapping one of the occurrences with a
candidate cell of a different integer. The function starts with \code{starting_dist = 3} and increases it
by \code{1} until the algorithm no longer converges or \code{stop_iter} iterations have been performed.
This version evaluates candidate swaps using both the mean pairwise distance and a centrality penalty,
and it uses candidate sampling to reduce computation.
}
\examples{
set.seed(123)
X <- matrix(sample(c(rep(1:10, 2), 11:50), replace = FALSE), ncol = 10)
B <- swap_pairs(
  X,
  starting_dist = 3,
  stop_iter = 50,
  lambda = 0.5,
  dist_method = "euclidean",
  candidate_sample_size = 3
)
B$optim_design

}
