% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimNDVI.R
\name{SimNDVI}
\alias{SimNDVI}
\title{NDVI simulation}
\usage{
SimNDVI(s, sw, sstar, kA, kR, Nmax, Nmin, N0)
}
\arguments{
\item{s}{A vector with soil moisture}

\item{sw}{Soil moisture at wilting point}

\item{sstar}{Soil moisture below field capacity point}

\item{kA}{Constant of assimilation}

\item{kR}{Constant of respiration}

\item{Nmax}{Maximum NDVI of the vegetation}

\item{Nmin}{Minimum NDVI of the vegetation}

\item{N0}{Initial condiction of NDVI. If it is missing, the average of Nmax and Nmin will be used}
}
\value{
NDVI series
}
\description{
This function simulates the NDVI based on soil moisture and vegetation parameters. Numerical solution.
}
\details{
NDVI simulation
}
\examples{
rain = 10 * RainPoisson(ndays = 365, lambda = 0.05, alpha = 0.60)
s = swb_f(R = rain, Rstar = 3, Emax = 5, Ew = 0.5, Ks = 2000, b = 4.38, Zr = 400,
n = 0.5, sh = 0.01, sw = 0.10, sstar = 0.25, s0 = 0.10, nsteps = 48, gr = T)[,3]
NDVI = SimNDVI(s, sw = 0.10, sstar = 0.35, kA = 0.064, kR = 0.011,
Nmax = 0.93, Nmin = 0.26, N0 = 0.5)
}
