% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRI.R
\name{convolve_design_matrix}
\alias{convolve_design_matrix}
\title{Convolve Events with HRF to Construct Design Matrices}
\usage{
convolve_design_matrix(
  timeseries,
  events,
  factors = NULL,
  contrasts = NULL,
  covariates = NULL,
  add_constant = TRUE,
  hrf_model = "glover",
  cell_coding = NULL,
  scale = TRUE,
  high_pass = TRUE,
  high_pass_model = "cosine",
  cut_off = 1e-12
)
}
\arguments{
\item{timeseries}{A data frame containing fMRI time series data with columns 'subjects', 'run', 'time', and at least one ROI column}

\item{events}{A data frame containing event information with required columns \code{subjects}, \code{run}, \code{onset}, \code{duration}, \code{event_type}, and \code{modulation}}

\item{factors}{A named list mapping factor names to event types}

\item{contrasts}{A named list of contrast matrices for each factor}

\item{covariates}{A character vector of event types to include as covariates}

\item{add_constant}{A boolean specifying whether a 1 should be included to the design matrix post convolution}

\item{hrf_model}{A character string specifying the HRF model to use ('glover', 'spm', 'glover + derivative', or 'spm + derivative')}

\item{cell_coding}{A character vector of factor names to use cell coding for}

\item{scale}{A boolean indicating whether to scale the design matrix.}

\item{high_pass}{Logical indicating whether to apply high-pass filtering.
Alternatively, specifying 'add' adds the regressors to the design matrix}

\item{high_pass_model}{Character indicating which type of high-pass filtering to apply ('cosine', 'poly')}

\item{cut_off}{A numeric value specifying the cutoff for the high-pass filter}
}
\value{
A list containing the design matrices
}
\description{
This function convolves events with the HRF to construct design matrices for fMRI analysis.
}
\examples{
# Generate a simple example timeseries
ts <- data.frame(
  subjects = rep(1, 100),
  run = rep(1, 100),
  time = seq(0, 99),
  ROI1 = rnorm(100)
)

# Generate example events
events <- data.frame(
  subjects = rep(1, 4),
  run = rep(1, 4),
  onset = c(10, 30, 50, 70),
  duration = rep(0.5, 4),
  event_type = c("hard", "easy", "hard", "easy"),
  modulation = c(1, 1, 1, 1)
)

# Build design matrices
design_matrices <-  convolve_design_matrix(
  timeseries = ts,
  events = events,
  factors = list(difficulty = c("hard", "easy")),
  contrasts = list(difficulty = matrix(c(-1, 1)))
)
}
